import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { GraduationCap, MapPin, Star, Users, Calendar } from "lucide-react";
import Link from "next/link";

const schools = [
  {
    name: "London School of English",
    country: "İngiltere",
    city: "Londra",
    rating: 4.8,
    students: 2500,
    price: "5.000₺",
    duration: "4 hafta",
    image: "🏫"
  },
  {
    name: "EF New York",
    country: "Amerika",
    city: "New York",
    rating: 4.9,
    students: 3000,
    price: "6.500₺",
    duration: "4 hafta",
    image: "🏫"
  },
  {
    name: "ILSC Toronto",
    country: "Kanada",
    city: "Toronto",
    rating: 4.7,
    students: 2200,
    price: "5.500₺",
    duration: "4 hafta",
    image: "🏫"
  },
  {
    name: "Goethe Institut",
    country: "Almanya",
    city: "Berlin",
    rating: 4.9,
    students: 1800,
    price: "4.500₺",
    duration: "4 hafta",
    image: "🏫"
  },
  {
    name: "Don Quijote Barcelona",
    country: "İspanya",
    city: "Barselona",
    rating: 4.6,
    students: 2000,
    price: "4.200₺",
    duration: "4 hafta",
    image: "🏫"
  },
  {
    name: "LSI Sydney",
    country: "Avustralya",
    city: "Sidney",
    rating: 4.8,
    students: 1500,
    price: "5.800₺",
    duration: "4 hafta",
    image: "🏫"
  },
];

export default function SchoolsPage() {
  return (
    <div className="pt-20">
      <section className="bg-gradient-to-br from-blue-50 to-emerald-50 py-20 px-4">
        <div className="max-w-7xl mx-auto text-center">
          <Badge className="mb-6 bg-blue-100 text-blue-700 hover:bg-blue-200">
            Dil Okulları
          </Badge>
          <h1 className="text-5xl md:text-6xl font-bold mb-6">
            Dünyanın En İyi Dil Okulları
          </h1>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            200'den fazla akredite dil okuluna uygun fiyatlarla kayıt olun. Hayalinizdeki ülkede dil öğrenin.
          </p>
        </div>
      </section>

      <section className="py-16 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-4 gap-6 mb-12">
            {[
              { label: "Ülke", count: "20+" },
              { label: "Dil Okulu", count: "200+" },
              { label: "Öğrenci", count: "5000+" },
              { label: "Dil", count: "15+" },
            ].map((item, idx) => (
              <Card key={idx} className="p-6 text-center border-2">
                <div className="text-3xl font-bold text-blue-600 mb-2">{item.count}</div>
                <div className="text-gray-600">{item.label}</div>
              </Card>
            ))}
          </div>

          <div className="mb-12">
            <h2 className="text-2xl font-bold mb-6">Filtrele</h2>
            <div className="flex flex-wrap gap-4">
              {["Tümü", "İngiltere", "Amerika", "Kanada", "Almanya", "İspanya", "Avustralya"].map((filter) => (
                <Button key={filter} variant={filter === "Tümü" ? "default" : "outline"} className={filter === "Tümü" ? "bg-blue-600" : ""}>
                  {filter}
                </Button>
              ))}
            </div>
          </div>

          <h2 className="text-3xl font-bold mb-8">Popüler Dil Okulları</h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {schools.map((school) => (
              <Card key={school.name} className="overflow-hidden hover:shadow-2xl transition-all border-2">
                <div className="bg-gradient-to-br from-blue-100 to-emerald-100 p-12 text-center text-6xl">
                  {school.image}
                </div>
                <div className="p-6">
                  <div className="flex items-center justify-between mb-3">
                    <Badge className="bg-blue-100 text-blue-700">{school.country}</Badge>
                    <div className="flex items-center">
                      <Star className="h-4 w-4 text-yellow-500 fill-yellow-500 mr-1" />
                      <span className="font-bold">{school.rating}</span>
                    </div>
                  </div>
                  <h3 className="text-xl font-bold mb-2">{school.name}</h3>
                  <div className="flex items-center text-gray-600 mb-4">
                    <MapPin className="h-4 w-4 mr-1" />
                    <span className="text-sm">{school.city}</span>
                  </div>
                  <div className="grid grid-cols-2 gap-4 mb-4 text-sm">
                    <div className="flex items-center">
                      <Users className="h-4 w-4 mr-2 text-gray-500" />
                      <span>{school.students} öğrenci</span>
                    </div>
                    <div className="flex items-center">
                      <Calendar className="h-4 w-4 mr-2 text-gray-500" />
                      <span>{school.duration}</span>
                    </div>
                  </div>
                  <div className="text-2xl font-bold text-blue-600 mb-4">
                    {school.price}
                    <span className="text-sm text-gray-500">/ay</span>
                  </div>
                  <Link href={`/schools/${school.name.toLowerCase().replace(/\s/g, '-')}`}>
                    <Button className="w-full bg-blue-600 hover:bg-blue-700">
                      Detayları Gör
                    </Button>
                  </Link>
                </div>
              </Card>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 px-4 bg-gray-50">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-3xl font-bold mb-6">Hizmetlerimiz</h2>
          <div className="grid md:grid-cols-3 gap-6">
            {[
              { title: "Okul Kaydı", desc: "Ücretsiz kayıt danışmanlığı" },
              { title: "Konaklama", desc: "Aile yanı veya yurt seçenekleri" },
              { title: "Vize Desteği", desc: "Öğrenci vizesi başvurusu" },
            ].map((service) => (
              <Card key={service.title} className="p-6">
                <GraduationCap className="h-10 w-10 text-blue-600 mx-auto mb-3" />
                <h3 className="font-bold mb-2">{service.title}</h3>
                <p className="text-sm text-gray-600">{service.desc}</p>
              </Card>
            ))}
          </div>
        </div>
      </section>
    </div>
  );
}
