import Link from "next/link";
import { Button } from "@/components/ui/button";
import { Card } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import {
  Plane,
  GraduationCap,
  FileText,
  Clock,
  Shield,
  Users,
  CheckCircle2,
  ArrowRight,
  Globe,
  Wallet
} from "lucide-react";

export default function Home() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-emerald-50 via-white to-blue-50 pt-20 pb-32 px-4">
        <div className="max-w-7xl mx-auto">
          <div className="text-center max-w-4xl mx-auto">
            <Badge className="mb-6 bg-emerald-100 text-emerald-700 hover:bg-emerald-200 border-emerald-200">
              Türkiye'nin En Uygun Vize ve Eğitim Danışmanlık Platformu
            </Badge>
            <h1 className="text-5xl md:text-7xl font-bold mb-6 bg-gradient-to-r from-emerald-600 to-blue-600 bg-clip-text text-transparent">
              Ucuza Vize
            </h1>
            <p className="text-xl md:text-2xl text-gray-600 mb-8 leading-relaxed">
              Yurtdışı eğitim hayallerinizi en uygun fiyatlarla gerçeğe dönüştürün.
              Vize işlemleri ve dil okulu kayıtları için güvenilir çözüm ortağınız.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link href="/visa">
                <Button size="lg" className="bg-emerald-600 hover:bg-emerald-700 text-lg px-8 py-6">
                  Vize Başvurusu Yap
                  <ArrowRight className="ml-2 h-5 w-5" />
                </Button>
              </Link>
              <Link href="/schools">
                <Button size="lg" variant="outline" className="text-lg px-8 py-6 border-2">
                  Dil Okullarını İncele
                  <GraduationCap className="ml-2 h-5 w-5" />
                </Button>
              </Link>
            </div>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mt-20 max-w-5xl mx-auto">
            {[
              { number: "50+", label: "Ülke" },
              { number: "200+", label: "Dil Okulu" },
              { number: "5000+", label: "Mutlu Öğrenci" },
              { number: "%98", label: "Başarı Oranı" }
            ].map((stat, index) => (
              <Card key={index} className="p-6 text-center border-2 hover:shadow-lg transition-shadow">
                <div className="text-3xl md:text-4xl font-bold text-emerald-600 mb-2">
                  {stat.number}
                </div>
                <div className="text-gray-600 font-medium">{stat.label}</div>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-24 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4">
              Neden Ucuza Vize?
            </h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Yurtdışı eğitim yolculuğunuzda size en iyi hizmeti sunmak için buradayız
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {[
              {
                icon: Wallet,
                title: "Uygun Fiyatlar",
                description: "Piyasanın en uygun vize işlem ücretleri ve dil okulu kayıt fiyatları"
              },
              {
                icon: Shield,
                title: "Güvenilir Hizmet",
                description: "Uzman danışmanlarımız ve %98 başarı oranıyla güvenle işlem yapın"
              },
              {
                icon: Clock,
                title: "Hızlı İşlem",
                description: "Başvurunuz en kısa sürede değerlendirilir ve sonuçlandırılır"
              },
              {
                icon: FileText,
                title: "Kolay Başvuru",
                description: "Online formlarla evrakları kolayca yükleyin, süreci takip edin"
              },
              {
                icon: Users,
                title: "7/24 Destek",
                description: "Deneyimli danışman ekibimiz her zaman yanınızda"
              },
              {
                icon: Globe,
                title: "50+ Ülke",
                description: "Dünyanın her yerinden dil okulu ve vize seçenekleri"
              }
            ].map((feature, index) => (
              <Card key={index} className="p-8 hover:shadow-xl transition-all border-2 hover:border-emerald-200">
                <feature.icon className="h-12 w-12 text-emerald-600 mb-4" />
                <h3 className="text-xl font-bold mb-3">{feature.title}</h3>
                <p className="text-gray-600 leading-relaxed">{feature.description}</p>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* How It Works */}
      <section className="py-24 px-4 bg-gradient-to-b from-gray-50 to-white">
        <div className="max-w-7xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4">
              Nasıl Çalışır?
            </h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              3 basit adımda vize işleminizi tamamlayın veya dil okuluna kayıt olun
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-12 max-w-5xl mx-auto">
            {[
              {
                step: "1",
                title: "Başvuru Yapın",
                description: "Online formu doldurun, gerekli evrakları yükleyin ve ödeme bilgilerinizi girin"
              },
              {
                step: "2",
                title: "Değerlendirme",
                description: "Uzman ekibimiz başvurunuzu inceler ve size en uygun seçenekleri sunar"
              },
              {
                step: "3",
                title: "Onay ve Teslimat",
                description: "Vizeniz onaylanır veya okul kaydınız tamamlanır. Süreç boyunca bilgilendirilirsiniz"
              }
            ].map((item, index) => (
              <div key={index} className="relative">
                <div className="flex flex-col items-center text-center">
                  <div className="w-20 h-20 rounded-full bg-emerald-600 text-white flex items-center justify-center text-3xl font-bold mb-6 shadow-lg">
                    {item.step}
                  </div>
                  <h3 className="text-2xl font-bold mb-4">{item.title}</h3>
                  <p className="text-gray-600 leading-relaxed">{item.description}</p>
                </div>
                {index < 2 && (
                  <ArrowRight className="hidden md:block absolute top-10 -right-6 h-8 w-8 text-emerald-300" />
                )}
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="py-24 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-2 gap-12">
            {/* Vize İşlemleri */}
            <Card className="p-10 border-2 hover:shadow-2xl transition-all">
              <Plane className="h-16 w-16 text-emerald-600 mb-6" />
              <h3 className="text-3xl font-bold mb-4">Vize İşlemleri</h3>
              <p className="text-gray-600 mb-6 text-lg leading-relaxed">
                Turist, öğrenci, iş vizesi ve daha fazlası için hızlı ve güvenilir başvuru hizmeti
              </p>
              <ul className="space-y-3 mb-8">
                {[
                  "Tüm vize türleri için başvuru",
                  "Evrak kontrolü ve danışmanlık",
                  "Randevu organizasyonu",
                  "Başvuru takip sistemi"
                ].map((item, index) => (
                  <li key={index} className="flex items-start">
                    <CheckCircle2 className="h-6 w-6 text-emerald-600 mr-3 flex-shrink-0 mt-0.5" />
                    <span className="text-gray-700">{item}</span>
                  </li>
                ))}
              </ul>
              <Button className="w-full bg-emerald-600 hover:bg-emerald-700 text-lg py-6">
                Vize Başvurusu Yap
              </Button>
            </Card>

            {/* Dil Okulları */}
            <Card className="p-10 border-2 hover:shadow-2xl transition-all">
              <GraduationCap className="h-16 w-16 text-blue-600 mb-6" />
              <h3 className="text-3xl font-bold mb-4">Dil Okulları</h3>
              <p className="text-gray-600 mb-6 text-lg leading-relaxed">
                Dünyanın en iyi dil okullarına uygun fiyatlarla kayıt olun
              </p>
              <ul className="space-y-3 mb-8">
                {[
                  "200+ akredite dil okulu",
                  "Kurs karşılaştırma ve seçim",
                  "Konaklama organizasyonu",
                  "Online kayıt ve ödeme"
                ].map((item, index) => (
                  <li key={index} className="flex items-start">
                    <CheckCircle2 className="h-6 w-6 text-blue-600 mr-3 flex-shrink-0 mt-0.5" />
                    <span className="text-gray-700">{item}</span>
                  </li>
                ))}
              </ul>
              <Link href="/schools">
                <Button className="w-full bg-blue-600 hover:bg-blue-700 text-lg py-6">
                  Dil Okullarını İncele
                </Button>
              </Link>
            </Card>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-24 px-4 bg-gradient-to-r from-emerald-600 to-blue-600 text-white">
        <div className="max-w-4xl mx-auto text-center">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            Hayalinizdeki Eğitime Bugün Başlayın
          </h2>
          <p className="text-xl mb-10 opacity-90">
            Uzman ekibimiz size en uygun vize ve eğitim çözümlerini sunmak için hazır
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/contact">
              <Button size="lg" className="bg-white text-emerald-600 hover:bg-gray-100 text-lg px-8 py-6">
                Ücretsiz Danışmanlık Al
              </Button>
            </Link>
            <Link href="/contact">
              <Button size="lg" variant="outline" className="border-2 border-white text-white hover:bg-white hover:text-emerald-600 text-lg px-8 py-6">
                İletişime Geç
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </div>
  );
}
