"use client";

import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { FileText, Clock, CheckCircle2, User, Settings, LogOut } from "lucide-react";
import Link from "next/link";
import { useRouter } from "next/navigation";
import { toast } from "sonner";

const applications = [
  { id: 1, type: "Vize", country: "İngiltere", status: "İnceleniyor", date: "15 Ocak 2025" },
  { id: 2, type: "Dil Okulu", school: "EF New York", status: "Onaylandı", date: "10 Ocak 2025" },
  { id: 3, type: "Vize", country: "Almanya", status: "Evrak Bekleniyor", date: "8 Ocak 2025" },
];

export default function DashboardPage() {
  const router = useRouter();

  const handleLogout = () => {
    toast.success("Çıkış yapıldı");
    setTimeout(() => {
      router.push("/");
    }, 500);
  };
  return (
    <div className="pt-20 min-h-screen bg-gray-50">
      <div className="max-w-7xl mx-auto px-4 py-12">
        <div className="grid md:grid-cols-4 gap-8">
          {/* Sidebar */}
          <Card className="p-6 h-fit">
            <div className="text-center mb-6">
              <div className="w-20 h-20 bg-gradient-to-r from-emerald-600 to-blue-600 rounded-full mx-auto mb-4 flex items-center justify-center text-white text-2xl font-bold">
                AY
              </div>
              <h3 className="font-bold text-lg">Ahmet Yılmaz</h3>
              <p className="text-sm text-gray-600">ahmet@email.com</p>
            </div>
            <nav className="space-y-2">
              <Button variant="ghost" className="w-full justify-start">
                <User className="mr-2 h-4 w-4" />
                Profilim
              </Button>
              <Button variant="ghost" className="w-full justify-start">
                <FileText className="mr-2 h-4 w-4" />
                Başvurularım
              </Button>
              <Button variant="ghost" className="w-full justify-start">
                <Settings className="mr-2 h-4 w-4" />
                Ayarlar
              </Button>
              <Button variant="ghost" className="w-full justify-start text-red-600 hover:text-red-700" onClick={handleLogout}>
                <LogOut className="mr-2 h-4 w-4" />
                Çıkış Yap
              </Button>
            </nav>
          </Card>

          {/* Main Content */}
          <div className="md:col-span-3 space-y-8">
            {/* Stats */}
            <div className="grid md:grid-cols-3 gap-6">
              <Card className="p-6">
                <FileText className="h-8 w-8 text-blue-600 mb-3" />
                <div className="text-3xl font-bold mb-1">3</div>
                <div className="text-gray-600">Toplam Başvuru</div>
              </Card>
              <Card className="p-6">
                <Clock className="h-8 w-8 text-yellow-600 mb-3" />
                <div className="text-3xl font-bold mb-1">1</div>
                <div className="text-gray-600">Beklemede</div>
              </Card>
              <Card className="p-6">
                <CheckCircle2 className="h-8 w-8 text-green-600 mb-3" />
                <div className="text-3xl font-bold mb-1">1</div>
                <div className="text-gray-600">Onaylandı</div>
              </Card>
            </div>

            {/* Applications */}
            <Card className="p-6">
              <div className="flex items-center justify-between mb-6">
                <h2 className="text-2xl font-bold">Başvurularım</h2>
                <Link href="/visa">
                  <Button className="bg-emerald-600 hover:bg-emerald-700">
                    Yeni Başvuru
                  </Button>
                </Link>
              </div>

              <div className="space-y-4">
                {applications.map((app) => (
                  <Card key={app.id} className="p-6 border-l-4 border-l-emerald-600 hover:shadow-lg transition-shadow">
                    <div className="flex flex-col md:flex-row md:items-center justify-between gap-4">
                      <div className="flex-1">
                        <div className="flex items-center gap-3 mb-2">
                          <Badge className="bg-blue-100 text-blue-700">{app.type}</Badge>
                          <Badge variant={
                            app.status === "Onaylandı" ? "default" :
                            app.status === "İnceleniyor" ? "secondary" :
                            "outline"
                          }>
                            {app.status}
                          </Badge>
                        </div>
                        <h3 className="font-bold text-lg mb-1">
                          {app.country || app.school}
                        </h3>
                        <p className="text-sm text-gray-600">Başvuru Tarihi: {app.date}</p>
                      </div>
                      <Button variant="outline">Detayları Gör</Button>
                    </div>
                  </Card>
                ))}
              </div>
            </Card>

            {/* Quick Actions */}
            <Card className="p-6">
              <h2 className="text-2xl font-bold mb-6">Hızlı İşlemler</h2>
              <div className="grid md:grid-cols-2 gap-4">
                <Link href="/visa">
                  <Button className="w-full bg-emerald-600 hover:bg-emerald-700 h-20 text-lg">
                    Vize Başvurusu Yap
                  </Button>
                </Link>
                <Link href="/schools">
                  <Button className="w-full bg-blue-600 hover:bg-blue-700 h-20 text-lg">
                    Dil Okulu Kayıt
                  </Button>
                </Link>
              </div>
            </Card>
          </div>
        </div>
      </div>
    </div>
  );
}
